﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Net.Sockets;
using System.Threading;
using System.Net;


namespace CS_iSMS_Tester
{
    class TCPserver
    {
        private TcpListener tcpListener; // .NET class used to create TCP server.
        private Thread listenThread; // Used to create new thread, so current thread doesn't hang.
        public EventArgs e = null; // Blank event arguement.
        public delegate void MsgHandler(); //String serverProtocol); //, EventArgs e); // Delegate is used to make call back function.
        public event MsgHandler MsgAlert;
        private bool Running = false; // Tracks whether server should be running.
        public String iSMSresponse = "";


        // Sart Server
        public void Start(int ServerPort)
        {
            Running = true;
            // Create new TCPListener class and listen on port sent.
            this.tcpListener = new TcpListener(IPAddress.Any, ServerPort);
            // Create new thread to listen for TCP connections. 
            // Otherwise the current thread will hang while waiting for connections.
            this.listenThread = new Thread(new ThreadStart(ListenForClients));
            this.listenThread.Start();
        }
    

        // Listen for TCP connections
        private void ListenForClients()
        {
            this.tcpListener.Start();
            // Continue listening for TCP connections until Running is set to false.
            while (Running)
            {
                TcpClient client = this.tcpListener.AcceptTcpClient(); //blocks until a client has connected to the server
                //create a thread to handle communication with connected client
                Thread clientThread = new Thread(new ParameterizedThreadStart(HandleClientComm));
                clientThread.Start(client);
            }
        }


        // Handle Communication with a Client
        private void HandleClientComm(object client)
        {
            TcpClient tcpClient = (TcpClient)client;
            NetworkStream clientStream = tcpClient.GetStream(); // Get stream to send/receive data with remote Client.
            ASCIIEncoding encoder = new ASCIIEncoding();
            try
            {
                // Send welcome message to client.
                byte[] buffer = encoder.GetBytes("Connected\r\n");
                clientStream.Write(buffer, 0, buffer.Length);
                clientStream.Flush();
            }
            catch
            {
                return;
            }
            
            byte[] message = new byte[6000];
            int bytesRead;
            String ThreadMsg=""; // String to hold messages received.
            // Read messages until TCP connection closed. Add all messages to ThreadMsg.
            while (true)
            {
                bytesRead = 0;
                try
                { bytesRead = clientStream.Read(message, 0, 4096); } //blocks until a client sends a message
                catch
                { break; } //a socket error has occured

                if (bytesRead == 0) break; //the client has disconnected from the server

                //message has successfully been received. Add to ThreadMsg.
                ThreadMsg = ThreadMsg + encoder.GetString(message, 0, bytesRead);
            }
            tcpClient.Close();
            iSMSresponse = ThreadMsg;

            // TCP connection is closed. Message is complete.

            // Call the function set a the Message Handler. If it has been set.
            if (MsgAlert != null)
            {
                MsgAlert.Invoke(); //"TCP"); //, e);
            }
        }


        // Set the function passed to SetEventHandler as the function to be called when a request is received.
        public void SetEventHandler(MsgHandler MsgHandlerFunc)
        {
            this.MsgAlert += new MsgHandler(MsgHandlerFunc);
        }


        // Shutdown Server
        public void CloseServer()
        {
            Running = false;
            if (listenThread !=null) listenThread.Abort();
            if (tcpListener != null)
            {
                tcpListener.Stop();
                tcpListener.Server.Close();
            }
        }
    }
}
